#include "CodeTemplateTree.h"

/* 
	  
*/
CodeTemplateTree::CodeTemplateTree(QWidget* parent):QTreeWidget(parent)
{
	this->MakeNameTemplate();
	this->MakeCodeTemplate();
	connect(this, SIGNAL(itemDoubleClicked(QTreeWidgetItem*, int)), this->parent()->parent(), SLOT(DisplayCodeTemplate()));
}

/* 
	͸ ҷ Ʈ ϼ
*/
void CodeTemplateTree::MakeTreeView()
{
	this->CreataPerformingAndShowItem();
	this->CreataSqlSyntaxItem();
	this->CreataStoredProcedureItem();
	this->CreataWorkingSchemaItem();
}

/* 
	Performing Administrative Tasks & Show Statements 
*/
void CodeTemplateTree::CreataPerformingAndShowItem()
{
	QIcon folderIcon("images/treeFolder.png");
	QIcon codeIcon("images/code.png");
	QTreeWidgetItem* buffer;

	QTreeWidgetItem* procedure = new QTreeWidgetItem(this, QStringList("Performing Administrative Tasks"));
	procedure->setIcon(0, folderIcon);
	QTreeWidgetItem* procedure1 = new QTreeWidgetItem(procedure, QStringList("Database Management"));
	procedure1->setIcon(0, folderIcon);
	buffer = new QTreeWidgetItem(procedure1, QStringList("Alter Database"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure1, QStringList("Create Database"));
	buffer->setIcon(0, codeIcon);
	
	QTreeWidgetItem* procedure2 = new QTreeWidgetItem(this, QStringList("Show Statements"));
	procedure2->setIcon(0, folderIcon);
	buffer = new QTreeWidgetItem(procedure2, QStringList("Show Create Procedure"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure2, QStringList("Show Create View"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure2, QStringList("Show Databases"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure2, QStringList("Show Function Status"));
	buffer->setIcon(0, codeIcon);
}


/* 
	SQLSyntax 
*/
void CodeTemplateTree::CreataSqlSyntaxItem()
{
	QIcon folderIcon("images/treeFolder.png");
	QIcon codeIcon("images/code.png");
	QTreeWidgetItem* buffer;

	QTreeWidgetItem* procedure3 = new QTreeWidgetItem(this, QStringList("SQLSyntax"));
	QTreeWidgetItem* procedure4 = new QTreeWidgetItem(procedure3, QStringList("DML Statements"));
	procedure3->setIcon(0, folderIcon);
	procedure4->setIcon(0, folderIcon);
	
	buffer = new QTreeWidgetItem(procedure4, QStringList("Delete"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Insert"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Insert with Select Clause"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Insert with Set Clause"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Multi-table Delete"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Multi-table Update"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Replace"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Truncate"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure4, QStringList("Update"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure5 = new QTreeWidgetItem(procedure3, QStringList("SQL Queries"));
	procedure5->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure5, QStringList("Full Join"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Group"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Join"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Left Join"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Like"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Right Join"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Select"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Select with Aliases"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Union"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure5, QStringList("Where"));
	buffer->setIcon(0, codeIcon);
}

/* 
	Stored Procedure Syntax 
*/
void CodeTemplateTree::CreataStoredProcedureItem()
{
	QIcon folderIcon("images/treeFolder.png");
	QIcon codeIcon("images/code.png");
	QTreeWidgetItem* buffer;

	QTreeWidgetItem* procedure6 = new QTreeWidgetItem(this, QStringList("Stored Procedure Syntax"));
	QTreeWidgetItem* procedure7 = new QTreeWidgetItem(procedure6, QStringList("Conditions and Handlers"));
	procedure6->setIcon(0, folderIcon);
	procedure7->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure7, QStringList("Condition"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure7, QStringList("Handler"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure8 = new QTreeWidgetItem(procedure6, QStringList("Control Structures"));
	procedure8->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure8, QStringList("Case"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("If-Then"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("If-Then-Else"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("If-Then-Elseif"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("Iterate"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("Labeled Loop"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("Leave"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("Loop"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("Repeat"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure8, QStringList("While"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure9 = new QTreeWidgetItem(procedure6, QStringList("Cursors"));
	procedure9->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure9, QStringList("Close Cursor"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure9, QStringList("Declare Cursor"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure9, QStringList("Fetch Cursor"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure9, QStringList("Open Cursor"));
	buffer->setIcon(0, codeIcon);
}


/* 
	Working With Schema Objects 
*/
void CodeTemplateTree::CreataWorkingSchemaItem()
{
	QIcon folderIcon("images/treeFolder.png");
	QIcon codeIcon("images/code.png");
	QTreeWidgetItem* buffer;

	QTreeWidgetItem* procedure10 = new QTreeWidgetItem(this, QStringList("Working With Schema Objects"));
	procedure10->setIcon(0, folderIcon);
	QTreeWidgetItem* procedure11 = new QTreeWidgetItem(procedure10, QStringList("Events"));
	procedure11->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure11, QStringList("Alter Event"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure11, QStringList("Create Event"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure11, QStringList("Create Event with Interval"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure11, QStringList("Drop Event"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure12 = new QTreeWidgetItem(procedure10, QStringList("Stored Procedures"));
	procedure12->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure12, QStringList("Alter Function"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure12, QStringList("Alter Procedure"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure12, QStringList("Drop Function"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure12, QStringList("Drop Procedure"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure12, QStringList("Function with Parameters"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure12, QStringList("Procedure with Parameters"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure12, QStringList("Procedure without Parameters"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure13 = new QTreeWidgetItem(procedure10, QStringList("Tables"));
	procedure13->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure13, QStringList("Alter Table"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure13, QStringList("Create Merge Table"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure13, QStringList("Create Table"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure13, QStringList("Create Table with Options Definition"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure13, QStringList("Drop Table"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure14 = new QTreeWidgetItem(procedure10, QStringList("Triggers"));
	procedure14->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure14, QStringList("Create Trigger"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure14, QStringList("Drop Trigger"));
	buffer->setIcon(0, codeIcon);

	QTreeWidgetItem* procedure15 = new QTreeWidgetItem(procedure10, QStringList("Views"));
	procedure15->setIcon(0, folderIcon);

	buffer = new QTreeWidgetItem(procedure15, QStringList("Alter View"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure15, QStringList("Create View"));
	buffer->setIcon(0, codeIcon);
	buffer = new QTreeWidgetItem(procedure15, QStringList("Drop View"));
	buffer->setIcon(0, codeIcon);
}


/* 
	ڵ ø    
*/
void CodeTemplateTree::MakeNameTemplate()
{
	this->nameTemplate << "Alter Database" << "Create Database" << "Show Create Procedure"
		<< "Show Create View" << "Show Databases" << "Show Function Status" << "Delete"
		<< "Insert" << "Insert with Select Clause" << "Insert with Set Clause" << "Multi-table Delete"
		<< "Multi-table Update" << "Replace" << "Truncate" << "Update" << "Full Join" << "Group" 
		<< "Join" << "Left Join" << "Like" << "Right Join" << "Select" << "Select with Aliases" 
		<< "Union" << "Where" << "Condition" << "Handler"<< "Case"<< "If-Then"<< "If-Then-Else"
		<< "If-Then-Elseif"<< "Iterate" << "Labeled Loop"<< "Leave"<< "Loop"<< "Repeat"<< "While"
		<< "Close Cursor" << "Declare Cursor"<< "Fetch Cursor"<< "Open Cursor"<< "Alter Event"<< "Create Event"
		<< "Create Event with Interval" << "Drop Event"<< "Alter Function" << "Alter Procedure" << "Drop Function"
		<< "Drop Procedure" << "Function with Parameters" << "Procedure with Parameters"
		<< "Procedure without Parameters" << "Alter Table" << "Create Merge Table" << "Create Table"
		<< "Create Table with Options Definition" << "Drop Table" << "Create Trigger" << "Drop Trigger"
		<< "Alter View" << "Create View" << "Drop View";
}


/* 
	õ ۿ شǴ  ȯ
*/
QString& CodeTemplateTree::FindCodeTemplate(QString& name)
{
	int index = this->nameTemplate.indexOf(name);

	return (this->codeTemplate)[index];
}


/* 
	ڵ ø  
*/
void CodeTemplateTree::MakeCodeTemplate()
{
	QString sql("\n ALTER DATABASE [DB1]\n DEFAULT CHARACTER SET [utf8] DEFAULT COLLATE utf8_bin;");
	this->codeTemplate << sql;
	sql = "\n CREATE DATABASE [DB1];";
	this->codeTemplate << sql;
	sql = "\n SHOW CREATE PROCEDURE [procedure_name];";
	this->codeTemplate << sql;
	sql = "\n SHOW CREATE VIEW [view1];";
	this->codeTemplate << sql;
	sql = "\n SHOW DATABASES;";
	this->codeTemplate << sql;
	sql = "\n SHOW FUNCTION STATUS LIKE [function_name];";
	this->codeTemplate << sql;
	sql = "\n DELETE LOW_PRIORITY QUICK \n FROM [TABLE1] WHERE [COLUMN1] = [value1]\n LIMIT 100;";
	this->codeTemplate << sql;
	sql = "\n INSERT HIGH_PRIORITY INTO [TABLE1](\n COLUMN1, COLUMN2)\n VALUES (value1, value2)";
	this->codeTemplate << sql;
	sql = "\n INSERT LOW_PRIORITY IGNORE\n INTO [TABLE1] (COLUMN11, COLUMN12)\n SELECT COLUMN21, COLUMN22 FROM [TABLE2]\n ON DUPLICATE KEY UPDATE COLUMN11 = COLUMN21 *10;";
	this->codeTemplate << sql;
	sql = "\n INSERT DELAYED INTO [TABLE1]\n SET COLUMN1 = 'String';";
	this->codeTemplate << sql;
	sql = "\n DELETE [TABLE1]\n FROM TABLE1,TABLE2\n WHERE TABLE1.COLUMN1 = TABLE2.COLUMN1;";
	this->codeTemplate << sql;
	sql = "\n UPDATE IGNORE [TABLE1,TABLE2]\n SET TABLE1.COLUMN1 = TABLE2.COLUMN1\n WHERE TABLE1.COLUMN2 = 'String';";
	this->codeTemplate << sql;
	sql = "\n REPLACE LOW_PRIORITY INTO [TABLE1](\n COLUMN1, COLUMN2)\n VALUES (value1, value2);";
	this->codeTemplate << sql;
	sql = "\n TRUNCATE TABLE [TABLE1];";
	this->codeTemplate << sql;
	sql = "\n UPDATE LOW_PRIORITY [TABLE1]\n SET COLUMN1 = value1\n WHERE COLUMN2 = value2;";
	this->codeTemplate << sql;
	sql = "\n SELECT [TABLE1.COLUMN1, TABLE2.COLUMN2]\n FROM [TABLE1] FULL OUTER JOIN [TABLE2]\n ON [TABLE1.JOIN_COLUMN1] = TABLE2.JOIN_COLUMN2;";
	this->codeTemplate << sql;
	sql = "\n SELECT COLUMN1, COUNT(COLUMN2)\n FROM [TABLE1]\n GROUP BY COLUMN1 \n ORDER BY COLUMN1;";
	this->codeTemplate << sql;
	sql = "\n SELECT [TABLE1.COLUMN1, TABLE2.COLUMN2]\n FROM [TABLE1] JOIN TABLE2 \n ON [TABLE1.JOIN_COLUMN1] = [TABLE2.JOIN_COLUMN2];";
	this->codeTemplate << sql;
	sql = "\n SELECT [TABLE1.COLUMN1, TABLE2.COLUMN2]\n FROM [TABLE1] LEFT OUTER JOIN [TABLE2]\n ON [TABLE1.JOIN_COLUMN1] = [TABLE2.JOIN_COLUMN2];";
	this->codeTemplate << sql;
	sql = "\n SELECT * FROM [TABLE1] \n WHERE COLUMN1 LIKE '%a%';";
	this->codeTemplate << sql;
	sql = "\n SELECT [TABLE1.COLUMN1, TABLE2.COLUMN2]\n FROM [TABLE1] RIGHT OUTER JOIN [TABLE2]\n ON [TABLE1.JOIN_COLUMN1] = [TABLE2.JOIN_COLUMN2];";
	this->codeTemplate << sql;
	sql = "\n SELECT * FROM \n [TABLE1];";
	this->codeTemplate << sql;
	sql = "\n SELECT [T1.COLUMN1, T2.COLUMN2]\n FROM [TABLE1] T1, [TABLE2] T2\n WHERE T1.COLUMN3 = T2.COLUMN4;";
	this->codeTemplate << sql;
	sql = "\n SELECT COLUMN1\n FROM [TABLE1]\n UNION SELECT COLUMN2\n FROM [TABLE2];";
	this->codeTemplate << sql;
	sql = "\n SELECT * FROM [EMP_]\n WHERE [DEPTNO] > 10 \n ORDER BY [EMPNO];";
	this->codeTemplate << sql;
	sql = "\n DECLARE [CURSOR1] CONDITION \n FOR SQLSTATE '23000'";
	this->codeTemplate << sql;
	sql = "\n DECLARE [CONTINUE] HANDLER \n FOR SQLSTATE SQLWARNING;";
	this->codeTemplate << sql;
	sql = "\n CASE [A] WHEN THEN \n ELSE \n END CASE;";
	this->codeTemplate << sql;
	sql = "\n IF [TRUE] THEN \n END IF;";
	this->codeTemplate << sql;
	sql = "\n IF [TRUE] THEN \n ELSE \n END IF;";
	this->codeTemplate << sql;
	sql = "\n IF [TRUE] THEN \n ELSEIF \n ELSE \n END IF;";
	this->codeTemplate << sql;
	sql = "\n ITERATE [label1];";
	this->codeTemplate << sql;
	sql = "\n [label1]: LOOP \n END LOOP label1;";
	this->codeTemplate << sql;
	sql = "\n LEAVE [label1];";
	this->codeTemplate << sql;
	sql = "\n LOOP \n\n END LOOP;";
	this->codeTemplate << sql;
	sql = "\n REPEAT \n\n UNTIL [TRUE] \n END REPEAT;";
	this->codeTemplate << sql;
	sql = "\n WHILE [TRUE] DO \n END WHILE;";
	this->codeTemplate << sql;
	sql = "\n CLOSE [CURSOR1];";
	this->codeTemplate << sql;
	sql = "\n DECLARE [CURSOR1] CURSOR \n FOR;";
	this->codeTemplate << sql;
	sql = "\n FETCH [CURSOR1] INTO [variable1]";
	this->codeTemplate << sql;
	sql = "\n OPEN [CURSOR1];";
	this->codeTemplate << sql;
	sql = "\n ALTER EVENT [EVENT1] \n ON SCHEDULE EVERY 12 HOUR \n STARTS CURRENT_TIMESTAMP + '2006-02-10 23:59:00' \n ENABLE;";
	this->codeTemplate << sql;
	sql = "\n CREATE EVENT IF NOT EXISTS [EVENT1] \n ON SCHEDULE AT '2008-02-10 23:59:00' \n ON COMPLETION NOT PRESERVE \n DISABLE COMMENT 'comment this event' \n DO";
	this->codeTemplate << sql;
	sql = "\n CREATE EVENT IF NOT EXISTS [EVENT1] \n ON SCHEDULE EVERY [1 DAY] STARTS '2006-02-10 23:59:00' \n ON COMPLETION PRESERVE \n ENABLE \n COMMENT 'comment this event' \n DO";
	this->codeTemplate << sql;
	sql = "\n DROP EVENT IF EXISTS [EVENT1];";
	this->codeTemplate << sql;
	sql = "\n ALTER FUNCTION [function_name] \n CONTAINS SQL COMMENT \n 'You must have the ALTER ROUTINE privilege for the routine';";
	this->codeTemplate << sql;
	sql = "\n ALTER PROCEDURE [procedure_name] \n SQL SECURITY DEFINER COMMENT 'Alter procedure characteristics';";
	this->codeTemplate << sql;
	sql = "\n DROP FUNCTION IF EXISTS [function1];";
	this->codeTemplate << sql;
	sql = "\n DROP PROCEDURE IF EXISTS [procedure_name];";
	this->codeTemplate << sql;
	sql = "\n CREATE FUNCTION [function1] ( \n PARAM1 INT, PARAM2 VARCHAR2) \n RETURNS [varchar2] \n BEGIN \n\n RETURN ; \n END;";
	this->codeTemplate << sql;
	sql = "\n CREATE PROCEDURE [procedure1]( \n IN PARAM1 VARCHAR2, OUT PARAM2 INT) \n CONTAINS SQL \n BEGIN \n\n END;";
	this->codeTemplate << sql;
	sql = "\n CREATE PROCEDURE [procedure1]() \n BEGIN \n DECLARE variable1 VARCHAR(20); \n END;";
	this->codeTemplate << sql;
	sql = "\n ALTER TABLE [USER1.TABLE1]( \n ADD INDEX [index1] (COLUMN1));";
	this->codeTemplate << sql;
	sql = "\n CREATE TABLE [merge_table1]( \n COLUMN1 INT(4) NOT NULL AUTO_INCREMENT, \n COLUMN2 VARCHAR(20)); \n	TYPE = MERGE UNION = (TABLE1, TABLE2) INSERT_METHOD = LAST;";
	this->codeTemplate << sql;
	sql = "\n CREATE TABLE IF NOT EXISTS [TABLE1](\n COLUMN1 INT(4) AUTO_INCREMENT, \n COLUMN2 VARCHAR(20) \n PRIMARY KEY (COLUMN1));";
	this->codeTemplate << sql;
	sql = "\n CREATE TABLE IF NOT EXISTS [TABLE1] ( \n COLUMN1 ) \n MAX_ROWS = 100 \n CHECKSUM = 0 \n	CHARACTER SET latin1 COLLATE latin1_swedish_ci";
	this->codeTemplate << sql;
	sql = "\n DROP TABLE IF EXISTS [TABLE1] CASCADE;";
	this->codeTemplate << sql;
	sql = "\n CREATE TRIGGER [user1.trigger1] \n AFTER INSERT \n  ON [TABLE1] \n  FOR EACH ROW \n BEGIN \n\n END;";
	this->codeTemplate << sql;
	sql = "\n DROP TRIGGER [USER1.TRIGGER1];";
	this->codeTemplate << sql;
	sql = "\n ALTER ALGORITHM = MERGE VIEW [VIEW1] (COLUMN1, COLUMN2) \n  AS \n  WITH LOCAL CHECK OPTION";
	this->codeTemplate << sql;
	sql = "\n CREATE OR REPLACE ALGORITHM = UNDEFINED VIEW [view1] \n  AS \n  WITH LOCAL CHECK OPTION";
	this->codeTemplate << sql;
	sql = "\n DROP VIEW IF EXISTS [view1] CASCADE;";
	this->codeTemplate << sql;
}

/* 
	  
*/
CodeTemplateTree::~CodeTemplateTree()
{
}

